#include <irrlicht.h>
using namespace irr;
using namespace core;
using namespace scene;
using namespace video;
using namespace io;
using namespace gui;
#ifdef _IRR_WINDOWS_
#pragma comment(lib, "Irrlicht.lib")
#pragma comment(linker, "/subsystem:windows /ENTRY:mainCRTStartup")
#endif
int main()
{
	IrrlichtDevice *device =
		createDevice( video::EDT_SOFTWARE, dimension2d<u32>(640, 480), 16,
			false, false, false, 0);
	if (!device)
		return 1;
	device->setWindowCaption(L"Irrlicht Engine Test");
	device->getFileSystem()->addZipFileArchive("vfs.zip");
	IVideoDriver* driver = device->getVideoDriver();
	ISceneManager* smgr = device->getSceneManager();
	// 1st cube
	ISceneNode* cube1 = smgr->addCubeSceneNode(10.0f);
	if (!cube1)
	{
		device->drop();
		return 1;
	}
	cube1->setMaterialTexture( 0, driver->getTexture("vfs/1.jpg") ); // an image with 2s
	cube1->setMaterialFlag(EMF_LIGHTING, false);
	// 2nd cube
	ISceneNode* cube2 = smgr->addCubeSceneNode(10.0f);
	if (!cube2)
	{
		device->drop();
		return 1;
	}
	cube2->setPosition(vector3df(12,0,0));
	cube2->setMaterialTexture( 0, driver->getTexture("vfs/dir1/1.jpg") ); // an image with 1s
	cube2->setMaterialFlag(EMF_LIGHTING, false);
	// 3rd cube
	ISceneNode* cube3 = smgr->addCubeSceneNode(10.0f);
	if (!cube3)
	{
		device->drop();
		return 1;
	}
	cube3->setPosition(vector3df(24,0,0));
	cube3->setMaterialTexture( 0, driver->getTexture("vfs/2.jpg") ); // an image with 2s
	cube3->setMaterialFlag(EMF_LIGHTING, false);

	smgr->addCameraSceneNode(0, vector3df(0,30,-40), vector3df(0,5,0));
	while(device->run())
	{
		driver->beginScene(true, true, SColor(255,100,101,140));
		smgr->drawAll();
		driver->endScene();
	}
	device->drop();
	return 0;
}
